// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#include "stringCommons.h"
#include "container.h"
#include "degub.h"

istream& operator>>(istream& aStream, const string& aString) {
	string temp;
	aStream >> temp;
	if(temp != aString)
		aStream.setstate(ios_base::failbit);
	return aStream;
}

bool GetWindowText(HWND hWnd, string& s) {
	int len = SendMessage(hWnd, WM_GETTEXTLENGTH, 0, 0);
	if(len <= 0) {
		RD(0);
	}
	Container<char> c(len + 1);
	int res = GetWindowText(hWnd, c, len + 1);
	MYASSERT(res == len);
	s = c;
	return true;
}

bool GetDlgItemText(HWND hDlg, int aDlgItem, string& s) {
	return GetWindowText(GetDlgItem(hDlg, aDlgItem), s);
}

int sprintf_s(Container<char>& dest, const char* format, ...) {
	va_list ap;
	va_start(ap, format);
	int res = vsprintf_s(dest, dest.size(), format, ap);
	va_end(ap);
	return res;
}

string make_space3(const string& src) {
	string buffer;
	for(size_t i=0; i < src.size(); i++) {
		buffer += src[i];
		int temp = (src.size() - i - 1);
		if(temp % 3 == 0 && temp != 0)
			buffer += ' ';
	}
	return buffer;
}